/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.test;

import filenet.vw.base.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;

public class ORBSessionTimerAnalyzer {
    private static final int IDLEN = 44;
    private static final int NLEN = 12;
    private static final int RPCLEN = 46;
    private static int USERLEN = 20;
    private static String HEADER = null;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S");
    private static final int I_DATE = 0;
    private static final int I_CLASSNAME = 1;
    private static final int I_ORB = 2;
    private static final int I_ID = 3;
    private static final int I_RPC = 4;
    private static final int I_STARTSTOP = 5;
    private static final int I_DURATION = 6;
    protected long[] m_rpcTimeBuckets = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
    protected long m_numStarts = 0L;
    protected long m_numStops = 0L;
    protected long m_numWereInProgress = 0L;
    protected long m_numStillInProgress = 0L;
    protected long m_maxProcessingTime = 0L;
    protected long m_maxIdleTime = 0L;
    Date m_initialDate = null;
    Date m_finalDate = null;
    TreeMap m_sessions = new TreeMap();
    private String m_fileName = null;
    private String m_results = null;
    private String m_headerDesc = null;
    private String m_SessionsDesc = null;

    private static String getLongString(long i) {
        return ORBSessionTimerAnalyzer.formatString(Long.toString(i), 12);
    }

    private static String formatString(String s, int len) {
        StringBuffer buf = new StringBuffer();
        buf.append(s);
        int nChars = len - buf.length();
        while (nChars-- > 0) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private static String getHEADER() {
        if (HEADER == null) {
            HEADER = "\n\n" + ORBSessionTimerAnalyzer.formatString("OrbID", 44) + ORBSessionTimerAnalyzer.formatString("User", USERLEN) + ORBSessionTimerAnalyzer.formatString("Max Proc", 12) + ORBSessionTimerAnalyzer.formatString("RPC", 46) + ORBSessionTimerAnalyzer.formatString("Max Idle", 12) + ORBSessionTimerAnalyzer.formatString("RPC", 46) + ORBSessionTimerAnalyzer.formatString("#Starts", 12) + ORBSessionTimerAnalyzer.formatString("#Stops", 12) + ORBSessionTimerAnalyzer.formatString("First Start RPC", 46) + ORBSessionTimerAnalyzer.formatString("Last Stop RPC", 46) + ORBSessionTimerAnalyzer.formatString("Was working on RPC", 46) + "Currently working RPC" + "\n";
        }
        return HEADER;
    }

    protected String getFileName() {
        return this.m_fileName;
    }

    public ORBSessionTimerAnalyzer(String fileName) throws IllegalArgumentException {
        this.m_fileName = fileName;
        if (!new File(fileName).exists()) {
            throw new IllegalArgumentException(fileName + " does not exist!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile() throws Exception {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.m_fileName));
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                SessionData data;
                String id;
                ++lineNo;
                String[] tokens = StringUtils.split(line, "\t");
                if (tokens.length < 7 || !tokens[1].equals("VWTimerLog") || !tokens[2].equals("ORB")) continue;
                this.m_finalDate = df.parse(tokens[0]);
                if (this.m_initialDate == null) {
                    this.m_initialDate = this.m_finalDate;
                }
                if (!this.m_sessions.containsKey(id = tokens[3])) {
                    data = new SessionData(id);
                    data.process(tokens);
                    this.m_sessions.put(id, data);
                    continue;
                }
                data = (SessionData)this.m_sessions.get(tokens[3]);
                data.process(tokens);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getHeaderOnly() {
        if (this.m_headerDesc == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("\n--------------------------------------------------------------------");
            buf.append("\nAnalyzing ").append(this.m_fileName);
            buf.append("\n--------------------------------------------------------------------");
            long elapsed = this.m_finalDate.getTime() - this.m_initialDate.getTime();
            buf.append("\nTime elapsed = ").append(elapsed).append(" ms").append("\n# of objects = ").append(this.m_sessions.size()).append("\nmax Processing Time = ").append(this.m_maxProcessingTime).append(" ms").append("\nmax Idle Time = ").append(this.m_maxIdleTime).append(" ms").append("\n\n# RPCs started = ").append(this.m_numStarts).append("\n# RPCs stopped = ").append(this.m_numStops).append("\n# RPCs were in progress = ").append(this.m_numWereInProgress).append("\n# RPCs are still in progress = ").append(this.m_numStillInProgress).append("\nAvg # of RPCs per second = ").append(1000L * this.m_numStarts / elapsed).append("\n\n0-1sec      1-2sec      2-3sec      3-4sec      4-5sec      >5sec\n").append(ORBSessionTimerAnalyzer.getLongString(this.m_rpcTimeBuckets[0])).append(ORBSessionTimerAnalyzer.getLongString(this.m_rpcTimeBuckets[1])).append(ORBSessionTimerAnalyzer.getLongString(this.m_rpcTimeBuckets[2])).append(ORBSessionTimerAnalyzer.getLongString(this.m_rpcTimeBuckets[3])).append(ORBSessionTimerAnalyzer.getLongString(this.m_rpcTimeBuckets[4])).append(ORBSessionTimerAnalyzer.getLongString(this.m_rpcTimeBuckets[5])).append("\n");
            this.m_headerDesc = buf.toString();
        }
        return this.m_headerDesc;
    }

    protected String getSessionDesc() {
        if (this.m_SessionsDesc == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(ORBSessionTimerAnalyzer.getHEADER());
            for (SessionData data : this.m_sessions.values()) {
                buf.append("\n").append(data);
            }
            this.m_SessionsDesc = buf.toString();
        }
        return this.m_SessionsDesc;
    }

    public String toString() {
        if (this.m_results == null) {
            this.m_results = this.getHeaderOnly() + this.getSessionDesc();
        }
        return this.m_results;
    }

    protected boolean contains(String id) {
        return this.m_sessions.containsKey(id);
    }

    public String[] getCommonObjects(ORBSessionTimerAnalyzer another) {
        if (another == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (String key : this.m_sessions.keySet()) {
            if (!another.contains(key)) continue;
            v.add(key);
        }
        return v.toArray(new String[0]);
    }

    protected static void printUsage() {
        System.out.println("--------------------------------------------------------------");
        System.out.println("Usage:");
        System.out.println("ORBSessionTimerAnalyzer <file1> <file2> .. <fileN>");
        System.out.println("\nWhere fileX has the timing data as enabled by filenet.pe.rpc.timer.level=FINEST");
        System.out.println("An example of timing traces:");
        System.out.println("2006.10.13 16:10:44.374  VWTimerLog  ORB    553d5030-0aa0-422a-89a0-df3d43d67a02    orb_rpc_getIndexFields\tstops 484");
        System.out.println("2006.10.13 16:10:44.405 VWTimerLog  ORB bf49d509-d8b6-4214-bb50-759b306887e2    orb_rpc_fetchQuery\tstarts 406");
        System.out.println("For verbose output, pass -Dverbose as the JVM system property.");
        System.exit(1);
    }

    public static void main(String[] args) {
        int i;
        int nArgs;
        boolean verbose = System.getProperty("verbose") != null;
        int n = nArgs = args == null ? 0 : args.length;
        if (nArgs == 0 || args[0].startsWith("-h")) {
            ORBSessionTimerAnalyzer.printUsage();
        }
        ORBSessionTimerAnalyzer[] lists = new ORBSessionTimerAnalyzer[nArgs];
        for (i = 0; i < nArgs; ++i) {
            try {
                lists[i] = new ORBSessionTimerAnalyzer(args[i]);
                lists[i].processFile();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < nArgs; ++i) {
            if (lists[i] == null) continue;
            System.out.println(lists[i].getHeaderOnly());
            if (!verbose) continue;
            System.out.println(lists[i].getSessionDesc());
        }
        for (i = 0; i < nArgs - 1; ++i) {
            if (lists[i] == null) continue;
            for (int j = i + 1; j < nArgs; ++j) {
                if (lists[j] == null) continue;
                System.out.println("\n===========================================================================");
                System.out.println("Checking objects of " + lists[i].getFileName() + " in " + lists[j].getFileName());
                String[] commonObjs = lists[i].getCommonObjects(lists[j]);
                int nItems = commonObjs == null ? 0 : commonObjs.length;
                System.out.println("Number of common objects=" + nItems);
                if (!verbose) continue;
                for (int k = 0; k < nItems; ++k) {
                    System.out.println(commonObjs[k]);
                }
            }
        }
    }

    class SessionData {
        public String id;
        public String user;
        public String orbId;
        public String firstStartRPC = null;
        public String lastStopRPC = null;
        public long numStarts = 0L;
        public long numStops = 0L;
        public boolean wasWorking = false;
        public boolean stillWorking = true;
        public long maxIdleTime = 0L;
        public long maxProcessingTime = 0L;
        public String rpcMaxIdleTime = null;
        public String rpcMaxProcessingTime = null;
        public String lastRPC = null;
        public String wasWorkingOnRPC = null;
        private String m_desc = null;

        public String toString() {
            if (this.m_desc == null) {
                StringBuffer buf = new StringBuffer();
                buf.append(ORBSessionTimerAnalyzer.formatString(this.orbId, 44)).append(ORBSessionTimerAnalyzer.formatString(this.user, USERLEN)).append(ORBSessionTimerAnalyzer.getLongString(this.maxProcessingTime)).append(ORBSessionTimerAnalyzer.formatString(this.rpcMaxProcessingTime, 46)).append(ORBSessionTimerAnalyzer.getLongString(this.maxIdleTime)).append(ORBSessionTimerAnalyzer.formatString(this.rpcMaxIdleTime, 46)).append(ORBSessionTimerAnalyzer.getLongString(this.numStarts)).append(ORBSessionTimerAnalyzer.getLongString(this.numStops)).append(ORBSessionTimerAnalyzer.formatString(this.firstStartRPC, 46)).append(ORBSessionTimerAnalyzer.formatString(this.lastStopRPC, 46)).append(ORBSessionTimerAnalyzer.formatString(this.wasWorking ? this.wasWorkingOnRPC : "N/A", 46)).append(this.stillWorking ? this.lastRPC : "N/A");
                this.m_desc = buf.toString();
            }
            return this.m_desc;
        }

        public SessionData(String id) {
            this.id = id;
            String[] ss = id.split(":");
            this.orbId = ss[0];
            if (ss.length > 1) {
                this.user = ss[1];
            }
        }

        public void process(String[] tokens) {
            this.lastRPC = tokens[4];
            long processingTime = Long.parseLong(tokens[6]);
            if (tokens[5].indexOf("starts") >= 0) {
                if (this.firstStartRPC == null) {
                    this.firstStartRPC = this.lastRPC;
                }
                ++this.numStarts;
                ++ORBSessionTimerAnalyzer.this.m_numStarts;
                ++ORBSessionTimerAnalyzer.this.m_numStillInProgress;
                this.stillWorking = true;
                if (this.maxIdleTime == 0L || processingTime > this.maxIdleTime) {
                    this.maxIdleTime = processingTime;
                    this.rpcMaxIdleTime = this.lastRPC;
                }
                if (ORBSessionTimerAnalyzer.this.m_maxIdleTime == 0L || processingTime > ORBSessionTimerAnalyzer.this.m_maxIdleTime) {
                    ORBSessionTimerAnalyzer.this.m_maxIdleTime = processingTime;
                }
            }
            if (tokens[5].indexOf("stops") >= 0) {
                int bucket;
                if (this.firstStartRPC == null) {
                    this.wasWorkingOnRPC = this.lastRPC;
                    ++ORBSessionTimerAnalyzer.this.m_numWereInProgress;
                    this.wasWorking = true;
                } else {
                    --ORBSessionTimerAnalyzer.this.m_numStillInProgress;
                    this.stillWorking = false;
                }
                this.lastStopRPC = this.lastRPC;
                ++this.numStops;
                ++ORBSessionTimerAnalyzer.this.m_numStops;
                if (processingTime > this.maxProcessingTime) {
                    this.maxProcessingTime = processingTime;
                    this.rpcMaxProcessingTime = this.lastRPC;
                }
                if (processingTime > ORBSessionTimerAnalyzer.this.m_maxProcessingTime) {
                    ORBSessionTimerAnalyzer.this.m_maxProcessingTime = processingTime;
                }
                if ((bucket = (int)(processingTime / 1000L)) > 5) {
                    bucket = 5;
                }
                int n = bucket;
                ORBSessionTimerAnalyzer.this.m_rpcTimeBuckets[n] = ORBSessionTimerAnalyzer.this.m_rpcTimeBuckets[n] + 1L;
            }
        }
    }
}

